<?php 
	include("includes/connection.php");
 	include("includes/function.php");
 	include("language/app_language.php");
 	include("smtp_email.php"); 
	
 	date_default_timezone_set("Asia/Kolkata");
	
	define("DEFAULT_PASSWORD",'123');

	$file_path = getBaseUrl();

	function is_favorite($id,$user_id='',$type='song')
	{	
 		global $mysqli;

 		$sql="SELECT * FROM tbl_favorite WHERE `post_id`='$id' AND `user_id`='$user_id' AND `type`='$type'";
 		$result=mysqli_query($mysqli, $sql);

 		if(mysqli_num_rows($result) > 0){
 			return 'true';
 		}
 		else{
 			return 'false';
 		}
	}

	function generateRandomPassword($length = 10) {
	    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
	    $charactersLength = strlen($characters);
	    $randomString = '';
	    for ($i = 0; $i < $length; $i++) {
	        $randomString .= $characters[rand(0, $charactersLength - 1)];
	    }
	    return $randomString;
	}

	define("PACKAGE_NAME",$settings_details['package_name']);
 	
	
	if($settings_details['envato_buyer_name']=='' OR $settings_details['envato_purchase_code']=='' OR $settings_details['envato_purchased_status']==0) {  

		$set['ONLINE_RADIO'][] =array('msg' => 'Purchase code verification failed!','success' => '-1' );	
		
		header( 'Content-Type: application/json; charset=utf-8' );
	    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
		die();
	}
	

 	function get_lang($lang_id)
 	{	
 		global $mysqli;

 		$query="SELECT * FROM tbl_language WHERE lid='".$lang_id."'";
		$res = mysqli_query($mysqli,$query)or die(mysqli_error($mysqli));
		$row =mysqli_fetch_assoc($res);

		return $row['language_name'];
 	}  

 	function get_total_cat_item($cat_id)
  	{ 
    	global $mysqli;   

    	$qry_songs="SELECT COUNT(*) as num FROM tbl_mp3 WHERE cat_id='".$cat_id."' AND status='1'";
     
    	$total_songs = mysqli_fetch_array(mysqli_query($mysqli,$qry_songs));
    	$total_songs = $total_songs['num'];
     
    	return $total_songs;

  	}

	function get_thumb($filename,$thumb_size)
	{	
		$file_path = getBaseUrl();

		return $thumb_path=$file_path.'thumb.php?src='.$filename.'&size='.$thumb_size;
	}

   function mail_sent($to,$recipient_name,$subject,$name,$msg)
	{
	global $file_path;
	global $app_lang;
	
	$message='<div style="background-color: #eee;" align="center"><br />
	<table style="font-family: OpenSans,sans-serif; color: #666666;" border="0" width="600" cellspacing="0" cellpadding="0" align="center" bgcolor="#FFFFFF">
	<tbody>
	<tr>
	<td colspan="2" bgcolor="#FFFFFF" align="center" ><img src="'.$file_path.'images/'.APP_LOGO.'" alt="logo" style="width:100px;height:auto;margin-top:10px;"/></td>
	</tr>
	<br>
	<br>
	<tr>
	<td colspan="2" bgcolor="#FFFFFF" align="center" style="padding-top:25px;">
	<img src="'.$file_path.'assets/images/thankyoudribble.gif" alt="header" auto-height="100" width="50%"/>
	</td>
	</tr>
	<tr>
	<td width="600" valign="top" bgcolor="#FFFFFF">
	<table style="font-family:OpenSans,sans-serif; color: #666666; font-size: 10px; padding: 15px;" border="0" width="100%" cellspacing="0" cellpadding="0" align="left">
	<tbody>
	<tr>
	<td valign="top">
	<table border="0" align="left" cellpadding="0" cellspacing="0" style="font-family:OpenSans,sans-serif; color: #666666; font-size: 10px; width:100%;">
	<tbody>
	<tr>
	<td>
	<p style="color: #717171; font-size: 24px; margin-top:0px; margin:0 auto; text-align:center;"><strong>'.$app_lang['welcome_lbl'].', '.addslashes(trim($name)).'</strong></p>
	<br>
	<p style="color:#15791c; font-size:18px; line-height:32px;font-weight:500;margin-bottom:30px; margin:0 auto; text-align:center;">'.$app_lang[$msg].'<br /></p>
	<br/>
	<p style="color:#999; font-size:17px; line-height:32px;font-weight:500; text-align:center;">'.$app_lang['thank_you_lbl'].' '.APP_NAME.'</p>
	</td>
	</tr>
	</tbody>
	</table>
	</td>
	</tr>
	</tbody>
	</table>
	</td>
	</tr>
	<tr>
	<td style="color: #262626; padding: 20px 0; font-size: 18px; border-top:5px solid #52bfd3;" colspan="2" align="center" bgcolor="#ffffff">'.$app_lang['email_copyright'].' '.APP_NAME.'.</td>
	</tr>
	</tbody>
	</table>
	</div>';

	send_email($to,$recipient_name,$subject,$message);
}
  
  	$get_method = checkSignSalt($_POST['data']);	 

  	if($get_method['method_name']=="city_list")
 	{
 		$jsonObj=array();
 		$data_arr=array();
		
		$cat_order=API_CITY_ORDER_BY;

		$query="SELECT * FROM tbl_city WHERE city_status='1' ORDER BY tbl_city.".$cat_order."";
		$sql = mysqli_query($mysqli,$query)or die(mysqli_error($mysqli));

		while($data = mysqli_fetch_assoc($sql))
		{
			$data_arr['cid'] = $data['cid'];
			$data_arr['city_name'] = $data['city_name'];
			$data_arr['city_tagline'] = $data['city_tagline'];
			 
			array_push($jsonObj,$data_arr);
		}

		$set['ONLINE_RADIO'] = $jsonObj;
		mysqli_free_result($sql);
		
		header( 'Content-Type: application/json; charset=utf-8' );
	    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
		die();
 	}
  	else if($get_method['method_name']=="add_report")
  	{		
  		$report_type=cleanInput($get_method['report_type']);
  		$report=cleanInput($get_method['report_text']);   
		
		$data = array(
	 	    'user_id'  => $get_method['report_user_id'],
			'post_id'  =>  $get_method['post_id'],
			'type'  =>  $report_type,
			'report'  =>  $report,
			'report_on'  =>  strtotime(date('d-m-Y h:i:s A'))
		);	

		$qry = Insert('tbl_reports',$data);

		$set['ONLINE_RADIO'][] = array('msg' => $app_lang['report_success'],'success'=>'1');
		
  		header( 'Content-Type: application/json; charset=utf-8' );
	    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
		die();
    }	
  	else if($get_method['method_name']=="get_radio_by_city_id")
	{
		$user_id=cleanInput($get_method['user_id']);
		
		$post_order_by=API_CITY_POST_ORDER_BY;

		$city_id=$get_method['city_id'];

		$quantity=$get_method['quantity'];	

		$jsonObj= array();	
	
		if($quantity!=0)
		{
			$query="SELECT * FROM tbl_radio
				LEFT JOIN tbl_city ON tbl_radio.`city_id`= tbl_city.`cid` 
				WHERE tbl_radio.`city_id`='$city_id' AND tbl_radio.`status`='1' AND tbl_city.`city_status`='1' ORDER BY tbl_radio.`id` ".$post_order_by." LIMIT $quantity";
		}
		else
		{
			$query="SELECT * FROM tbl_radio
				LEFT JOIN tbl_city ON tbl_radio.`city_id`= tbl_city.`cid` 
				WHERE tbl_radio.`city_id`='$city_id' AND tbl_radio.`status`='1' AND tbl_city.`city_status`='1' ORDER BY tbl_radio.`id` ".$post_order_by."";
		}
 
		$sql = mysqli_query($mysqli,$query)or die(mysqli_error($mysqli));

		while($data = mysqli_fetch_assoc($sql))
		{
			$row['id'] = $data['id'];
			$row['city_id'] = $data['city_id'];
			$row['radio_name'] = $data['radio_name'];
			$row['radio_url'] = $data['radio_url'];
			$row['radio_description'] = stripslashes($data['radio_description']);
			$row['radio_frequency'] = $data['radio_frequency'];			  
			$row['video_thumbnail_b'] = $file_path.'images/'.$data['radio_image'];
			$row['video_thumbnail_s'] = get_thumb('images/'.$data['radio_image'],'300x300');
			$row['views'] = $data['views'];

			$row['is_favorite'] = is_favorite($data['id'],$user_id,'radio');

			$row['share_link'] = $file_path.'view_radio.php?radio_id='.$data['id'];

			$row['language_name'] = get_lang($data['lang_id']);

			$row['cid'] = $data['cid'];
			$row['city_name'] = $data['city_name'];
			$row['city_tagline'] = $data['city_tagline']; 

			array_push($jsonObj,$row);
		
		}

		$set['ONLINE_RADIO'] = $jsonObj;
		
		header( 'Content-Type: application/json; charset=utf-8' );
	    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
		die();

		
	}
  	else if($get_method['method_name']=="lang_list")
 	{
 		$jsonObj= array();
		
		$lang_order=API_LANG_ORDER_BY;

		$query="SELECT * FROM tbl_language WHERE `language_status`='1' ORDER BY tbl_language.".$lang_order."";
		$sql = mysqli_query($mysqli,$query)or die(mysqli_error($mysqli));

		while($data = mysqli_fetch_assoc($sql))
		{
			  
			$row['lid'] = $data['lid'];
			$row['language_name'] = $data['language_name'];
			 
			array_push($jsonObj,$row);
		
		}

		$set['ONLINE_RADIO'] = $jsonObj;
		
		header( 'Content-Type: application/json; charset=utf-8' );
	    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
		die();
 	}
  	else if($get_method['method_name']=="get_radio_by_lang_id")
	{
		$post_order_by=API_CITY_POST_ORDER_BY;
		
		$lang_id=$get_method['lang_id'];	
		$user_id=$get_method['user_id'];	
		
		$quantity=$get_method['quantity'];	

		$jsonObj= array();	
	
		if($quantity!=0)
		{
			$query="SELECT * FROM tbl_radio
				LEFT JOIN tbl_language ON tbl_radio.`lang_id`= tbl_language.`lid` 
				WHERE tbl_radio.`lang_id`='$lang_id' AND tbl_radio.`status`='1' AND tbl_language.`language_status`='1' ORDER BY tbl_radio.`id` ".$post_order_by." LIMIT $quantity";
		}
		else
		{
			$query="SELECT * FROM tbl_radio
				LEFT JOIN tbl_language ON tbl_radio.`lang_id`= tbl_language.`lid` 
				WHERE tbl_radio.`lang_id`='$lang_id' AND tbl_radio.`status`='1' AND tbl_language.`language_status`='1' ORDER BY tbl_radio.`id` ".$post_order_by."";
		}
	 

		$sql = mysqli_query($mysqli,$query)or die(mysqli_error($mysqli));

		while($data = mysqli_fetch_assoc($sql))
		{
			$row['id'] = $data['id'];
			$row['lang_id'] = $data['lang_id'];
			$row['radio_name'] = $data['radio_name'];
			$row['radio_url'] = $data['radio_url'];
			$row['radio_description'] = stripslashes($data['radio_description']);
			$row['radio_frequency'] = $data['radio_frequency'];			  
			$row['video_thumbnail_b'] = $file_path.'images/'.$data['radio_image'];
			$row['video_thumbnail_s'] = get_thumb('images/'.$data['radio_image'],'300x300');
			$row['views'] = $data['views'];

			$row['is_favorite'] = is_favorite($data['id'],$user_id,'radio');

			$row['share_link'] = $file_path.'view_radio.php?radio_id='.$data['id'];

			$row['lid'] = $data['lid'];
			$row['language_name'] = $data['language_name'];

			array_push($jsonObj,$row);
		
		}

		$set['ONLINE_RADIO'] = $jsonObj;
		
		header( 'Content-Type: application/json; charset=utf-8' );
	    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
		die();

		
	}	 
  	else if($get_method['method_name']=="get_latest_radio")
	{
		$user_id=cleanInput($get_method['user_id']); 

		$limit=API_LATEST_LIMIT;

		$jsonObj= array();	
 
		$query="SELECT * FROM tbl_radio
				LEFT JOIN tbl_language ON tbl_radio.`lang_id`= tbl_language.`lid`
				LEFT JOIN tbl_city ON tbl_radio.`city_id`= tbl_city.`cid`
				WHERE tbl_radio.`status`='1' AND tbl_language.`language_status`='1' AND tbl_city.`city_status`='1'
				ORDER BY tbl_radio.`id` DESC LIMIT $limit";

		$sql = mysqli_query($mysqli,$query)or die(mysqli_error($mysqli));

		while($data = mysqli_fetch_assoc($sql))
		{
			$row['id'] = $data['id'];
			$row['city_id'] = $data['city_id'];
			$row['radio_name'] = $data['radio_name'];
			$row['radio_url'] = $data['radio_url'];
			$row['radio_description'] = stripslashes($data['radio_description']);
			$row['radio_frequency'] = $data['radio_frequency'];			  
			$row['video_thumbnail_b'] = $file_path.'images/'.$data['radio_image'];
			$row['video_thumbnail_s'] = get_thumb('images/'.$data['radio_image'],'300x300');
			$row['views'] = $data['views'];

			$row['is_favorite'] = is_favorite($data['id'],$user_id,'radio');

			$row['share_link'] = $file_path.'view_radio.php?radio_id='.$data['id'];
			
			$row['language_name'] = get_lang($data['lang_id']);

			$row['cid'] = $data['cid'];
			$row['city_name'] = $data['city_name'];
			$row['city_tagline'] = $data['city_tagline'];

			array_push($jsonObj,$row);
		
		}

		$set['ONLINE_RADIO'] = $jsonObj;
		
		header( 'Content-Type: application/json; charset=utf-8' );
	    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
		die();

	}	 
  	else if($get_method['method_name']=="get_single_radio")
	{
		$user_id=cleanInput($get_method['user_id']);

		$jsonObj=array();
		$data_arr=array();

		$radio_id=trim($get_method['radio_id']);

		$sql="SELECT * FROM tbl_radio
				LEFT JOIN tbl_language ON tbl_radio.`lang_id`= tbl_language.`lid`
				LEFT JOIN tbl_city ON tbl_radio.`city_id`= tbl_city.`cid`
				WHERE tbl_radio.`status`='1' AND tbl_language.`language_status`='1' AND tbl_city.`city_status`='1' AND tbl_radio.`id`='$radio_id'";

		$result = mysqli_query($mysqli,$sql)or die(mysqli_error($mysqli));
		
		while($data = mysqli_fetch_assoc($result))
		{
			$data_arr['id'] = $data['id'];
			$data_arr['city_id'] = $data['city_id'];
			$data_arr['lang_id'] = $data['lang_id'];
			$data_arr['radio_name'] = $data['radio_name'];
			$data_arr['radio_url'] = $data['radio_url'];
			$data_arr['radio_description'] = stripslashes($data['radio_description']);
			$data_arr['radio_frequency'] = $data['radio_frequency'];			  
			$data_arr['video_thumbnail_b'] = $file_path.'images/'.$data['radio_image'];
			$data_arr['video_thumbnail_s'] = get_thumb('images/'.$data['radio_image'],'300x300');
			$data_arr['views'] = $data['views'];

			$data_arr['is_favorite'] = is_favorite($data['id'],$user_id,'radio');

			$data_arr['share_link'] = $file_path.'view_radio.php?radio_id='.$radio_id;
			
			$data_arr['language_name'] = get_lang($data['lang_id']);

			$data_arr['cid'] = $data['cid'];
			$data_arr['city_name'] = $data['city_name'];
			$data_arr['city_tagline'] = $data['city_tagline'];
			  
			array_push($jsonObj,$data_arr);
		}
		
		$view_qry=mysqli_query($mysqli,"UPDATE tbl_radio SET `views` = `views` + 1 WHERE `id` = '$radio_id'");
 
		$set['ONLINE_RADIO'] = $jsonObj;
		mysqli_free_result($result);
		
		header( 'Content-Type: application/json; charset=utf-8' );
	    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
		die();
	}
  	else if($get_method['method_name']=="add_user_suggest")
	{

     	$ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);

		$image=date('dmYhis').rand(0,99999)."_user_suggest.".$ext;

		//Main Image
		$tpath1='images/'.$image;   

		if($ext!='png')  {
			$pic1=compress_image($_FILES["image"]["tmp_name"], $tpath1, 80);
		}
		else{
			$tmp = $_FILES['image']['tmp_name'];
			move_uploaded_file($tmp, $tpath1);
		}   
        
        $data = array( 
        	'user_id'  =>  trim($get_method['user_id']),
         	'title'  =>  addslashes($get_method['title']),
         	'description'  =>  addslashes($get_method['description']),
         	'image'  =>  $image,
         	'created_at'  =>  strtotime(date('d-m-Y h:i:s A')), 
        );    

        $qry = Insert('tbl_user_suggest',$data);
  				 
    	$set['ONLINE_RADIO'][]=array('msg' => $app_lang['suggest_msg'],'success'=>'1');
			  
		header( 'Content-Type: application/json; charset=utf-8' );
	    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
		die();
	}
  	else if($get_method['method_name']=="get_home_radio")
	{
		$user_id=cleanInput($get_method['user_id']);

		mysqli_query($mysqli, "ALTER TABLE `tbl_radio` CHANGE `views` `views` INT(11) NOT NULL DEFAULT '0'");

		$jsonObj= array();
		$data_arr= array();

		$sql="SELECT * FROM tbl_radio
				LEFT JOIN tbl_language ON tbl_radio.`lang_id`= tbl_language.`lid`
				LEFT JOIN tbl_city ON tbl_radio.`city_id`= tbl_city.`cid`
				WHERE tbl_radio.`status`='1' AND tbl_language.`language_status`='1' AND tbl_city.`city_status`='1' AND tbl_radio.`featured_radio`='1'
				ORDER BY tbl_radio.`id` DESC LIMIT 3";

		$result = mysqli_query($mysqli,$sql)or die(mysqli_error($mysqli));

		while($data = mysqli_fetch_assoc($result))
		{
			$data_arr['id'] = $data['id'];
			$data_arr['city_id'] = $data['city_id'];
			$data_arr['radio_name'] = $data['radio_name'];
			$data_arr['radio_url'] = $data['radio_url'];
			$data_arr['radio_description'] = stripslashes($data['radio_description']);
			$data_arr['radio_frequency'] = $data['radio_frequency'];			  
			$data_arr['video_thumbnail_b'] = $file_path.'images/'.$data['radio_image'];
			$data_arr['video_thumbnail_s'] = get_thumb('images/'.$data['radio_image'],'300x300');
			$data_arr['views'] = $data['views'];

			$data_arr['is_favorite'] = is_favorite($data['id'],$user_id,'radio');

			$data_arr['share_link'] = $file_path.'view_radio.php?radio_id='.$data['id'];

			$data_arr['language_name'] = get_lang($data['lang_id']);

			$data_arr['cid'] = $data['cid'];
			$data_arr['city_name'] = $data['city_name'];
			$data_arr['city_tagline'] = $data['city_tagline'];

			array_push($jsonObj,$data_arr);
		
		}

		$row['featured_list'] = $jsonObj;

		mysqli_free_result($result);

		$jsonObj= array();
		$data_arr= array();

		$sql="SELECT * FROM tbl_radio
				LEFT JOIN tbl_language ON tbl_radio.`lang_id`= tbl_language.`lid`
				LEFT JOIN tbl_city ON tbl_radio.`city_id`= tbl_city.`cid`
				WHERE tbl_radio.`status`='1' AND tbl_language.`language_status`='1' AND tbl_city.`city_status`='1'
				ORDER BY tbl_radio.`views` DESC LIMIT 3";	 
		 

		$result = mysqli_query($mysqli,$sql)or die(mysqli_error($mysqli));

		while($data = mysqli_fetch_assoc($result))
		{
			$data_arr['id'] = $data['id'];
			$data_arr['city_id'] = $data['city_id'];
			$data_arr['radio_name'] = $data['radio_name'];
			$data_arr['radio_url'] = $data['radio_url'];
			$data_arr['radio_description'] = stripslashes($data['radio_description']);
			$data_arr['radio_frequency'] = $data['radio_frequency'];			  
			$data_arr['video_thumbnail_b'] = $file_path.'images/'.$data['radio_image'];
			$data_arr['video_thumbnail_s'] = get_thumb('images/'.$data['radio_image'],'300x300');
			$data_arr['views'] = $data['views'];

			$data_arr['is_favorite'] = is_favorite($data['id'],$user_id,'radio');

			$data_arr['share_link'] = $file_path.'view_radio.php?radio_id='.$data['id'];

			$data_arr['language_name'] = get_lang($data['lang_id']);

			$data_arr['cid'] = $data['cid'];
			$data_arr['city_name'] = $data['city_name'];
			$data_arr['city_tagline'] = $data['city_tagline'];

			array_push($jsonObj,$data_arr);
		
		}

		$row['most_view_list'] = $jsonObj;

		mysqli_free_result($result);

		$jsonObj= array();
		$data_arr= array();	 
		 
		$sql="SELECT cid,category_name,category_image FROM tbl_category WHERE `status`='1' ORDER BY tbl_category.`category_name`";
		$result = mysqli_query($mysqli,$sql)or die(mysqli_error($mysqli));

		while($data = mysqli_fetch_assoc($result))
		{ 
			$data_arr['cid'] = $data['cid'];
			$data_arr['category_name'] = $data['category_name'];
			$data_arr['category_image'] = $file_path.'images/'.$data['category_image'];
			$data_arr['category_image_thumb'] = get_thumb('images/'.$data['category_image'],'300x300');

			$data_arr['total_items'] = get_total_cat_item($data['cid']);
  
			array_push($jsonObj,$data_arr);
		
		}

		$row['ondemand_cat_list'] = $jsonObj;

		mysqli_free_result($result);

		$set['ONLINE_RADIO'] = $row;
		
		header( 'Content-Type: application/json; charset=utf-8' );
	    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
		die();
	}
  	else if($get_method['method_name']=="get_featured_radio")
	{
		$user_id=cleanInput($get_method['user_id']);

		$jsonObj= array();	
		$data_arr= array();
 	
 		$sql="SELECT * FROM tbl_radio
				LEFT JOIN tbl_language ON tbl_radio.`lang_id`= tbl_language.`lid`
				LEFT JOIN tbl_city ON tbl_radio.`city_id`= tbl_city.`cid`
				WHERE tbl_radio.`status`='1' AND tbl_language.`language_status`='1' AND tbl_city.`city_status`='1' AND tbl_radio.`featured_radio`='1'
				ORDER BY tbl_radio.`id` DESC";

		$result = mysqli_query($mysqli,$sql)or die(mysqli_error($mysqli));

		while($data = mysqli_fetch_assoc($result))
		{
			$data_arr['id'] = $data['id'];
			$data_arr['city_id'] = $data['city_id'];
			$data_arr['radio_name'] = $data['radio_name'];
			$data_arr['radio_url'] = $data['radio_url'];
			$data_arr['radio_description'] = stripslashes($data['radio_description']);
			$data_arr['radio_frequency'] = $data['radio_frequency'];			  
			$data_arr['video_thumbnail_b'] = $file_path.'images/'.$data['radio_image'];
			$data_arr['video_thumbnail_s'] = get_thumb('images/'.$data['radio_image'],'300x300');
			$data_arr['views'] = $data['views'];

			$data_arr['is_favorite'] = is_favorite($data['id'],$user_id,'radio');

			$data_arr['share_link'] = $file_path.'view_radio.php?radio_id='.$data['id'];

			$data_arr['language_name'] = get_lang($data['lang_id']);

			$data_arr['cid'] = $data['cid'];
			$data_arr['city_name'] = $data['city_name'];
			$data_arr['city_tagline'] = $data['city_tagline'];

			array_push($jsonObj,$data_arr);
		
		}

		$set['ONLINE_RADIO'] = $jsonObj;

		mysqli_free_result($result);
		
		header( 'Content-Type: application/json; charset=utf-8' );
	    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
		die();

	}
  	else if($get_method['method_name']=="get_most_view")
	{
		$user_id=cleanInput($get_method['user_id']);

		$jsonObj= array();	 
		$data_arr= array();
		 
		$sql="SELECT * FROM tbl_radio
				LEFT JOIN tbl_language ON tbl_radio.`lang_id`= tbl_language.`lid`
				LEFT JOIN tbl_city ON tbl_radio.`city_id`= tbl_city.`cid`
				WHERE tbl_radio.`status`='1' AND tbl_language.`language_status`='1' AND tbl_city.`city_status`='1'
				ORDER BY tbl_radio.`views` DESC";

		$result = mysqli_query($mysqli,$sql)or die(mysqli_error($mysqli));

		while($data = mysqli_fetch_assoc($result))
		{
			$data_arr['id'] = $data['id'];
			$data_arr['city_id'] = $data['city_id'];
			$data_arr['radio_name'] = $data['radio_name'];
			$data_arr['radio_url'] = $data['radio_url'];
			$data_arr['radio_description'] = stripslashes($data['radio_description']);
			$data_arr['radio_frequency'] = $data['radio_frequency'];			  
			$data_arr['video_thumbnail_b'] = $file_path.'images/'.$data['radio_image'];
			$data_arr['video_thumbnail_s'] = get_thumb('images/'.$data['radio_image'],'300x300');
			$data_arr['views'] = $data['views'];

			$data_arr['is_favorite'] = is_favorite($data['id'],$user_id,'radio');

			$data_arr['language_name'] = get_lang($data['lang_id']);

			$data_arr['cid'] = $data['cid'];
			$data_arr['city_name'] = $data['city_name'];
			$data_arr['city_tagline'] = $data['city_tagline'];

			array_push($jsonObj,$data_arr);
		}
 
		$set['ONLINE_RADIO'] = $jsonObj;
		mysqli_free_result($result);
		
		header( 'Content-Type: application/json; charset=utf-8' );
	    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
		die();
	}
  	else if($get_method['method_name']=="get_search_radio")
	{
		$user_id=cleanInput($get_method['user_id']);

		$jsonObj= array();	
		$data_arr= array();

		$search_txt=cleanInput($get_method['search_text']);

		$sql="SELECT * FROM tbl_radio
				LEFT JOIN tbl_language ON tbl_radio.`lang_id`= tbl_language.`lid`
				LEFT JOIN tbl_city ON tbl_radio.`city_id`= tbl_city.`cid`
				WHERE tbl_radio.`status`='1' AND tbl_language.`language_status`='1' AND tbl_city.`city_status`='1' AND tbl_radio.`radio_name` LIKE '%$search_txt%'
				ORDER BY tbl_radio.`radio_name` DESC";

		$result = mysqli_query($mysqli,$sql)or die(mysqli_error($mysqli));

		while($data = mysqli_fetch_assoc($result))
		{
			$data_arr['id'] = $data['id'];
			$data_arr['city_id'] = $data['city_id'];
			$data_arr['radio_name'] = $data['radio_name'];
			$data_arr['radio_url'] = $data['radio_url'];
			$data_arr['radio_description'] = stripslashes($data['radio_description']);
			$data_arr['radio_frequency'] = $data['radio_frequency'];			  
			$data_arr['video_thumbnail_b'] = $file_path.'images/'.$data['radio_image'];
			$data_arr['video_thumbnail_s'] = get_thumb('images/'.$data['radio_image'],'300x300');
			$data_arr['views'] = $data['views'];

			$data_arr['is_favorite'] = is_favorite($data['id'],$user_id,'radio');

			$data_arr['share_link'] = $file_path.'view_radio.php?radio_id='.$data['id'];
	
			$data_arr['language_name'] = get_lang($data['lang_id']);

			$data_arr['cid'] = $data['cid'];
			$data_arr['city_name'] = $data['city_name'];
			$data_arr['city_tagline'] = $data['city_tagline'];

			array_push($jsonObj,$data_arr);
		}
		$set['ONLINE_RADIO'] = $jsonObj;
		mysqli_free_result($result);
		
		header( 'Content-Type: application/json; charset=utf-8' );
	    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
		die();

	}
  	else if($get_method['method_name']=="on_demand_cat")
 	{
 		
 		$jsonObj= array();
 		$data_arr = array();

		$sql="SELECT * FROM tbl_category WHERE `status`='1' ORDER BY tbl_category.`category_name`";
		$result = mysqli_query($mysqli,$sql)or die(mysqli_error($mysqli));

		while($data = mysqli_fetch_assoc($result))
		{ 
			$data_arr['cid'] = $data['cid'];
			$data_arr['category_name'] = $data['category_name'];
			$data_arr['category_image'] = $file_path.'images/'.$data['category_image'];
			$data_arr['category_image_thumb'] = get_thumb('images/'.$data['category_image'],'300x300');
			$data_arr['total_items'] = get_total_cat_item($data['cid']);
  
			array_push($jsonObj,$data_arr);		
		}

		$set['ONLINE_RADIO'] = $jsonObj;
		mysqli_free_result($result);
		
		header( 'Content-Type: application/json; charset=utf-8' );
	    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
		die();
 	}	 
  	else if($get_method['method_name']=="get_on_demand_cat_id")
	{
		$user_id=cleanInput($get_method['user_id']);

		$jsonObj= array();
		$data_arr=array();	
		
		$cat_id=cleanInput($get_method['on_demand_cat_id']);	

		$sql="SELECT * FROM tbl_mp3
				LEFT JOIN tbl_category ON tbl_mp3.`cat_id`= tbl_category.`cid` 
				WHERE tbl_mp3.`cat_id`='$cat_id' AND tbl_mp3.`status`='1' AND tbl_category.`status` ORDER BY tbl_mp3.`id` DESC";

		$result = mysqli_query($mysqli,$sql)or die(mysqli_error($mysqli));

		while($data = mysqli_fetch_assoc($result))
		{
			$data_arr['id'] = $data['id'];
			$data_arr['cat_id'] = $data['cat_id'];
 			$data_arr['mp3_type'] = $data['mp3_type'];
			$data_arr['mp3_title'] = $data['mp3_title'];
			
			$mp3_file=$data['mp3_url'];
			if($data['mp3_type']=='local'){
				$mp3_file=$file_path.'uploads/'.basename($data['mp3_url']);
			}

			$data_arr['mp3_url'] = $mp3_file;
 			 
			$data_arr['mp3_thumbnail_b'] = $file_path.'images/'.$data['mp3_thumbnail'];
			$data_arr['mp3_thumbnail_s'] = get_thumb('images/'.$data['mp3_thumbnail'],'300x300');
			 
			$data_arr['mp3_duration'] = $data['mp3_duration'];
 			$data_arr['mp3_description'] = stripslashes($data['mp3_description']);
 			$data_arr['total_views'] = $data['total_views'];

 			$data_arr['is_favorite'] = is_favorite($data['id'],$user_id);
  			
  			$data_arr['share_link'] = $file_path.'view_song.php?mp3_id='.$data['id'];

 			$data_arr['cid'] = $data['cid'];
			$data_arr['category_name'] = $data['category_name'];
			$data_arr['category_image'] = $file_path.'images/'.$data['category_image'];
			$data_arr['category_image_thumb'] = get_thumb('images/'.$data['category_image'],'300x300');

			array_push($jsonObj,$data_arr);
		
		}

		$set['ONLINE_RADIO'] = $jsonObj;
		
		header( 'Content-Type: application/json; charset=utf-8' );
	    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
		die();

	}
  	else if($get_method['method_name']=="get_on_demand_single")
	{
		$user_id=cleanInput($get_method['user_id']);

		$jsonObj=array();
		$data_arr=array();

		$mp3_id=cleanInput($get_method['on_demand_single']);
	
	    $sql="SELECT * FROM tbl_mp3
	    	LEFT JOIN tbl_category ON tbl_mp3.`cat_id`= tbl_category.`cid` 
			WHERE tbl_mp3.`status`='1' AND tbl_category.`status`='1' AND tbl_mp3.`id`='$mp3_id'";

		$result = mysqli_query($mysqli,$sql)or die(mysqli_error($mysqli));

		while($data = mysqli_fetch_assoc($result))
		{
			$data_arr['id'] = $data['id'];
			$data_arr['cat_id'] = $data['cat_id'];
 			$data_arr['mp3_type'] = $data['mp3_type'];
			$data_arr['mp3_title'] = $data['mp3_title'];
			$data_arr['mp3_url'] = $data['mp3_url'];
 			
 			$mp3_file=$data['mp3_url'];
			if($data['mp3_type']=='local'){
				$mp3_file=$file_path.'uploads/'.basename($data['mp3_url']);
			}

			$data_arr['mp3_url'] = $mp3_file;
			 
			$data_arr['mp3_thumbnail_b'] = $file_path.'images/'.$data['mp3_thumbnail'];
			$data_arr['mp3_thumbnail_s'] = get_thumb('images/'.$data['mp3_thumbnail'],'300x300');
			 
			$data_arr['mp3_duration'] = $data['mp3_duration'];
 			$data_arr['mp3_description'] = stripslashes($data['mp3_description']);
 			$data_arr['total_views'] = $data['total_views'];

 			$data_arr['is_favorite'] = is_favorite($data['id'],$user_id);
 			
  			$data_arr['share_link'] = $file_path.'view_song.php?mp3_id='.$mp3_id;

 			$data_arr['cid'] = $data['cid'];
			$data_arr['category_name'] = $data['category_name'];
			$data_arr['category_image'] = $file_path.'images/'.$data['category_image'];
			$data_arr['category_image_thumb'] = get_thumb('images/'.$data['category_image'],'300x300');

			array_push($jsonObj,$data_arr);
		
		}

		$view_qry=mysqli_query($mysqli,"UPDATE tbl_mp3 SET `total_views` = `total_views` + 1 WHERE `id` = '$mp3_id'");

		$set['ONLINE_RADIO'] = $jsonObj;
		
		header( 'Content-Type: application/json; charset=utf-8' );
	    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
		die();

	}
  	else if($get_method['method_name']=="get_themes")
	{
		$jsonObj=array();
		$data_arr=array();
		 
		$sql="SELECT * FROM tbl_theme ORDER BY tbl_theme.`id` DESC";
		$result = mysqli_query($mysqli, $sql)or die(mysqli_error($mysqli));

		while($data = mysqli_fetch_assoc($result))
		{
			$data_arr['id'] = $data['id'];
			$data_arr['gradient_color1'] = $data['gradient_color1'];
			$data_arr['gradient_color2'] = $data['gradient_color2'];
			 
			array_push($jsonObj,$data_arr);
		}

		$set['ONLINE_RADIO'] = $jsonObj;
		mysqli_free_result($result);
		
		header( 'Content-Type: application/json; charset=utf-8' );
	    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
		die();
 }else if($get_method['method_name']=="user_register"){

	$user_type=trim($get_method['type']); //Google, Normal, Facebook

	$email=addslashes(trim($get_method['email']));
	$auth_id=addslashes(trim($get_method['auth_id']));

	$name = filter_var($get_method['name'], FILTER_SANITIZE_STRING);

	$registration_on=strtotime(date('d-m-Y h:i A'));

	$to = $email;
	$recipient_name = $name;
	$subject = str_replace('###', APP_NAME, $app_lang['register_mail_lbl']);

	if($user_type=='Google' || $user_type=='google'){

		$qry="SELECT * FROM tbl_users WHERE (`email` = '$email' OR `auth_id`='$auth_id') AND `user_type`='Google'";
		$result = mysqli_query($mysqli,$qry) or die(mysqli_error($mysqli));
		
		if(mysqli_num_rows($result) == 0){
			
			$data = array(
				'user_type'=>'Google',
				'name'  => addslashes(trim($get_method['name'])),				    
				'email'  =>  addslashes(trim($get_method['email'])),
				'password'  =>  md5(DEFAULT_PASSWORD),
				'phone'  =>  addslashes(trim($get_method['phone'])),
				'registered_on'  =>  strtotime(date('d-m-Y h:i:s A')), 
				'status'  =>  '1'
			);		

			$qry = Insert('tbl_users',$data);	

			$user_id=mysqli_insert_id($mysqli);

			save_activity_log($user_id);

			mail_sent($to,$recipient_name,$subject,cleanInput($get_method['name']),'google_register_msg');

			$set['ONLINE_RADIO'][]=array('user_id' => strval($user_id),'name'=>$get_method['name'],'email'=>$get_method['email'], 'success'=>'1', 'msg' =>$app_lang['register_success'], 'auth_id' => $auth_id);

		}else{	

			$row = mysqli_fetch_assoc($result);

			if($row['status']==0)
			{
				$set['ONLINE_RADIO'][]=array('msg' =>$app_lang['account_deactive'],'success'=>'0');
			}
			else
			{  
				$set['ONLINE_RADIO'][]=array('user_id' => $row['id'], 'name'=>$row['name'], 'email'=>$row['email'], 'msg' => $app_lang['login_success'], 'auth_id' => $auth_id, 'success'=>'1');
			}
		}

	}
	else if($user_type=='Normal' || $user_type=='normal'){			

		$qry = "SELECT * FROM tbl_users WHERE tbl_users.`email` = '".$email."' AND tbl_users.`user_type`='Normal'";
		$result = mysqli_query($mysqli,$qry);
		$row = mysqli_fetch_assoc($result);

		if (!filter_var($get_method['email'], FILTER_VALIDATE_EMAIL)) 
			{
				$set['ONLINE_RADIO'][]=array('msg' => $app_lang['invalid_email_format'],'success'=>'0');
			}
			else if($row['email']!="")
			{
				$set['ONLINE_RADIO'][]=array('msg' => $app_lang['email_exist'],'success'=>'0');
			}else{

			$data = array(
				'user_type'=>'Normal',											 
				'name'  => addslashes(trim($get_method['name'])),				    
				'email'  =>  addslashes(trim($get_method['email'])),
				'password'  =>  md5(trim($get_method['password'])),
				'phone'  =>  addslashes(trim($get_method['phone'])),
				'registered_on'  =>  strtotime(date('d-m-Y h:i:s A')),
				'status'  =>  '1'
			);	

			$qry = Insert('tbl_users',$data);	

			$user_id=mysqli_insert_id($mysqli);

			mail_sent($to,$recipient_name,$subject,cleanInput($get_method['name']),'normal_register_msg');

			$set['ONLINE_RADIO'][]=array('user_id' => $user_id, 'name'=>$get_method['name'], 'email'=>$get_method['email'], 'msg' => $app_lang['register_success'], 'auth_id' => $auth_id, 'success'=>'1');
			}
		
	}
	else if($user_type=='Facebook' || $user_type=='facebook'){			

		$qry="SELECT * FROM tbl_users WHERE (`email` = '$email' AND `auth_id`='$auth_id') AND `user_type`='Facebook'";
		$result = mysqli_query($mysqli,$qry);
		
		if(mysqli_num_rows($result) == 0){

			$data = array(

				'user_type' => 'Facebook',
				'name'  => $name,				    
				'email'  =>  $email,
				'password'  =>  md5(DEFAULT_PASSWORD),
				'auth_id' => $auth_id,
				'phone'  =>  addslashes(trim($get_method['phone'])),
				'registered_on' => $registration_on,
				'status'  =>  '1'
			);		

			$qry = Insert('tbl_users',$data);	

			$user_id=mysqli_insert_id($mysqli);

			save_activity_log($user_id);

			mail_sent($to,$recipient_name,$subject,cleanInput($get_method['name']),'facebook_register_msg');

			$set=array('success' => '1','message' => '','user_id' => $user_id,'name'=>$get_method['name'],'email'=>$get_method['email'],'msg' => $app_lang['register_success'],'success'=>'1');
		}
		else{
			$row = mysqli_fetch_assoc($result);
			if($row['status']==0)
			{
				$set=array('msg' =>$app_lang['account_blocked'],'success'=>'0');
			}

			else
			{  
				$set=array('user_id' => $row['id'],'name'=>$row['name'],'email'=>$row['email'],'msg' => $app_lang['login_success'],'success'=>'1');
			}
		}
	}

	header( 'Content-Type: application/json; charset=utf-8' );
	echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE));
	die();

	}else if($get_method['method_name']=="user_login"){

	// simple login
	$email = filter_var($get_method['email'], FILTER_SANITIZE_EMAIL);
	$password = filter_var($get_method['password'], FILTER_SANITIZE_STRING);

	$sql_user = "SELECT * FROM tbl_users WHERE email = '$email' AND (`user_type`='Normal' OR `user_type`='normal') AND `id` <> 0"; 
	$res_user=mysqli_query($mysqli, $sql_user) or die('Error in fetch data ->'.mysqli_error($mysqli));

	if(mysqli_num_rows($res_user) > 0){
		$row=mysqli_fetch_assoc($res_user);

		if($row['status']==1){

			if($row['password']==md5($password)){

				$user_id=$row['id'];

				save_activity_log($user_id);

				$set['ONLINE_RADIO'][]=array('user_id' => $row['id'], 'name'=>$row['name'], 'email'=>$row['email'], 'msg' => $app_lang['login_success'], 'auth_id' => '', 'success'=>'1');

			}
			else{
				// invalid password
				$set['ONLINE_RADIO'][]=array('msg' =>$app_lang['invalid_password'],'success'=>'0');
			}
		}
		else{
			// account is deactivated
			$set['ONLINE_RADIO'][]=array('msg' =>$app_lang['account_deactive'],'success'=>'0');
		}

	}
	else{
		// email not found
		$set['ONLINE_RADIO'][]=array('msg' =>$app_lang['email_not_found'],'success'=>'0');
	}

	header( 'Content-Type: application/json; charset=utf-8' );
	echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
	die();
	}
  	else if($get_method['method_name']=="user_profile")
    {	
		$qry = "SELECT * FROM tbl_users WHERE id = '".$get_method['id']."'"; 
		$result = mysqli_query($mysqli,$qry);

		$row = mysqli_fetch_assoc($result);

		$set['ONLINE_RADIO'][]=array('user_id' => $row['id'],'name'=>$row['name'],'email'=>$row['email'],'phone'=>$row['phone'],'success'=>'1');
					
		header( 'Content-Type: application/json; charset=utf-8' );
	    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
		die();
  	}
  	else if($get_method['method_name']=="user_profile_update")
    {	
  		  
		$jsonObj= array();	
		
		$qry = "SELECT * FROM tbl_users WHERE id = '".$get_method['user_id']."'"; 
		$result = mysqli_query($mysqli,$qry);
		$row = mysqli_fetch_assoc($result);
 	 
 	 	if (!filter_var($get_method['email'], FILTER_VALIDATE_EMAIL)) 
		{
			$set['ONLINE_RADIO'][]=array('msg' => $app_lang['invalid_email_format'],'success'=>'0');

			header( 'Content-Type: application/json; charset=utf-8' );
			$json = json_encode($set);
			echo $json;
			 exit;
		}
		else if($row['email']==$get_method['email'] AND $row['id']!=$get_method['user_id'])
		{
			$set['ONLINE_RADIO'][]=array('msg' => $app_lang['email_exist'],'success'=>'0');

			header( 'Content-Type: application/json; charset=utf-8' );
			$json = json_encode($set);
			echo $json;
			exit;
		}
 	 	else if($get_method['password']!="")
		{
			$data = array(
			'name'  =>  $get_method['name'],
			'email'  =>  $get_method['email'],
			'password'  =>  md5($get_method['password']),
			'phone'  =>  $get_method['phone'] 
			);
		}
		else
		{
			$data = array(
			'name'  =>  $get_method['name'],
			'email'  =>  $get_method['email'],			 
			'phone'  =>  $get_method['phone'] 
			);
		}
 
		$user_edit=Update('tbl_users', $data, "WHERE id = '".$get_method['user_id']."'");
	 		 
		$set['ONLINE_RADIO'][]=array('msg'=>$app_lang['update_success'],'success'=>'1');

		header( 'Content-Type: application/json; charset=utf-8' );
		$json = json_encode($set);
		echo $json;
		exit;
 	}
  	else if($get_method['method_name']=="forgot_pass")
  	{	 

  		$email=addslashes(trim($get_method['user_email']));

		$qry = "SELECT * FROM tbl_users WHERE email = '$email' AND `user_type`='Normal' AND `id` <> 0"; 
		$result = mysqli_query($mysqli,$qry);
		$row = mysqli_fetch_assoc($result);
		
		if($row['email']!="")
		{
			$password=generateRandomPassword(7);
			
			$new_password=md5($password);

			$to = $row['email'];
			$recipient_name=$row['name'];
			// subject
			$subject = str_replace('###', APP_NAME, $app_lang['forgot_password_sub_lbl']);
 			
			$message='<div style="background-color: #f9f9f9;" align="center"><br />
					  <table style="font-family: OpenSans,sans-serif; color: #666666;" border="0" width="600" cellspacing="0" cellpadding="0" align="center" bgcolor="#FFFFFF">
					    <tbody>
					      <tr>
					        <td colspan="2" bgcolor="#FFFFFF" align="center"><img src="'.$file_path.'images/'.APP_LOGO.'" alt="header" style="width:100px;height:auto"/></td>
					      </tr>
					      <tr>
					        <td width="600" valign="top" bgcolor="#FFFFFF"><br>
					          <table style="font-family:OpenSans,sans-serif; color: #666666; font-size: 10px; padding: 15px;" border="0" width="100%" cellspacing="0" cellpadding="0" align="left">
					            <tbody>
					              <tr>
					                <td valign="top"><table border="0" align="left" cellpadding="0" cellspacing="0" style="font-family:OpenSans,sans-serif; color: #666666; font-size: 10px; width:100%;">
					                    <tbody>
					                      <tr>
					                        <td>
					                        	<p style="color: #262626; font-size: 24px; margin-top:0px;"><strong>'.$app_lang['dear_lbl'].' '.$row['name'].'</strong></p>
					                          <p style="color:#262626; font-size:20px; line-height:32px;font-weight:500;margin-top:5px;"><br>'.$app_lang['your_password_lbl'].': <span style="font-weight:400;">'.$password.'</span></p>
					                          <p style="color:#262626; font-size:17px; line-height:32px;font-weight:500;margin-bottom:30px;">'.$app_lang['thank_you_lbl'].' '.APP_NAME.'</p>

					                        </td>
					                      </tr>
					                    </tbody>
					                  </table></td>
					              </tr>
					               
					            </tbody>
					          </table></td>
					      </tr>
					      <tr>
					        <td style="color: #262626; padding: 20px 0; font-size: 18px; border-top:5px solid #52bfd3;" colspan="2" align="center" bgcolor="#ffffff">'.$app_lang['email_copyright'].' '.APP_NAME.'.</td>
					      </tr>
					    </tbody>
					  </table>
					</div>';

			send_email($to,$recipient_name,$subject,$message);

			$sql="UPDATE tbl_users SET `password`='$new_password' WHERE `id`='".$row['id']."'";
	      	mysqli_query($mysqli,$sql);
			 	  
			$set['ONLINE_RADIO'][]=array('msg' => $app_lang['password_sent_mail'],'success'=>'1');
		}
		else
		{  	 
			$set['ONLINE_RADIO'][]=array('msg' => $app_lang['email_not_found'],'success'=>'0');		
		}

		header( 'Content-Type: application/json; charset=utf-8' );
		echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE));
		die();

	}
  	else if($get_method['method_name']=="get_app_details")
	{
		$jsonObj= array();	

		$query="SELECT * FROM tbl_settings WHERE id='1'";
		$sql = mysqli_query($mysqli,$query)or die(mysqli_error($mysqli));

		while($data = mysqli_fetch_assoc($sql))
		{
			 
			$row['package_name'] = $data['package_name'];
			$row['app_name'] = $data['app_name'];
			$row['app_logo'] = $data['app_logo'];

			$row['app_fb_url'] = $data['app_fb_url'];
			$row['app_twitter_url'] = $data['app_twitter_url'];

			$row['app_version'] = $data['app_version'];
			$row['app_author'] = $data['app_author'];
			$row['app_contact'] = $data['app_contact'];
			$row['app_email'] = $data['app_email'];
			$row['app_website'] = $data['app_website'];
			$row['app_description'] = $data['app_description'];
 			$row['app_developed_by'] = $data['app_developed_by'];

 			$row['app_privacy_policy'] = stripslashes($data['app_privacy_policy']);
			
			if ($data['android_ad_network'] == 'admob') {
                $row['publisher_id'] = $data['publisher_id'];
            } else {
                $row['publisher_id'] = '';
            }
            
            $row['ad_network'] = $data['android_ad_network'];

			$row['interstital_ad'] = $data['interstital_ad'];
			$row['interstital_ad_type'] = $data['interstital_ad_type'];
			$row['interstital_ad_click'] = $data['interstital_ad_click'];

			if ($data['interstital_ad_type'] == 'facebook') {
                $row['interstital_ad_id'] = $data['interstital_facebook_id'];
            } else if ($data['interstital_ad_type'] == 'admob') {
                $row['interstital_ad_id'] = $data['interstital_ad_id'];
            }else if ($data['interstital_ad_type'] == 'applovins') {
                $row['interstital_ad_id'] = $data['interstitial_applovin_id'];
            } else if ($data['interstital_ad_type'] == 'startapp') {
                $row['interstital_ad_id'] = '';
            }
			
			$row['banner_ad'] = $data['banner_ad'];
			$row['banner_ad_type'] = $data['banner_ad_type'];

			if ($data['banner_ad_type'] == 'facebook') {
                $row['banner_ad_id'] = $data['banner_facebook_id'];
            } else if ($data['banner_ad_type'] == 'admob') {
                $row['banner_ad_id'] = $data['banner_ad_id'];
            }else if ($data['banner_ad_type'] == 'applovins') {
                $row['banner_ad_id'] = $data['banner_applovin_id'];
            } else if ($data['banner_ad_type'] == 'startapp') {
                $row['banner_ad_id'] = '';
            }

			$row['native_ad'] = $data['native_ad'];
			$row['native_ad_type'] = $data['native_ad_type'];

			if ($data['android_ad_network'] == 'startapp') {
                $row['startapp_app_id'] = $data['start_ads_id'];
            } else {
                $row['startapp_app_id'] = '';
            }

			if ($data['native_ad_type'] == 'facebook') {
                $row['native_ad_id'] = $data['native_facebook_id'];
            } else if ($data['native_ad_type'] == 'admob') {
                $row['native_ad_id'] = $data['native_ad_id'];
            }else if ($data['native_ad_type'] == 'applovins') {
                $row['native_ad_id'] = $data['native_applovin_id'];
            } else{
                $row['native_ad_id'] = '';
            }

			$row['native_position'] = $data['native_position'];

			$row['app_update_status'] = $data['app_update_status'];
            $row['app_new_version'] = $data['app_new_version'];
            $row['app_update_desc'] = stripslashes($data['app_update_desc']);
            $row['app_redirect_url'] = $data['app_redirect_url'];
            $row['cancel_update_status'] = $data['cancel_update_status'];

			array_push($jsonObj,$row);
			
		}

		$set['ONLINE_RADIO'] = $jsonObj;
		
		header( 'Content-Type: application/json; charset=utf-8' );
	    echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
		die();	
	}
	else if($get_method['method_name']=="favorite_post")
	{
		$jsonObj= array();	
		
		$post_id=$get_method['post_id'];
		$type=$get_method['type'];	//song/radio
		$user_id=$get_method['user_id'];

		$sql="SELECT * FROM tbl_favorite WHERE `post_id`='$post_id' AND `user_id`='$user_id' AND `type`='$type'";
		$res=mysqli_query($mysqli, $sql);

		if(mysqli_num_rows($res) == 0){

			$data = array(
                'post_id'  =>  $post_id,
                'user_id'  =>  $user_id,
                'type'  =>  $type,
                'created_at'  =>  strtotime(date('d-m-Y h:i:s A')), 
            );

            $qry = Insert('tbl_favorite',$data);

			$set['ONLINE_RADIO'][]=array('msg'=>$app_lang['favourite_success'],'success'=>'1');
		}
		else{
			$deleteSql="DELETE FROM tbl_favorite WHERE `post_id`='$post_id' AND `user_id`='$user_id' AND `type`='$type'";
			
			if(mysqli_query($mysqli, $deleteSql)){
				$set['ONLINE_RADIO'][]=array('msg'=>$app_lang['favourite_remove_success'],'success'=>'0');	
			}
			else{
				$set['ONLINE_RADIO'][]=array('msg'=>$app_lang['favourite_remove_error'],'success'=>'1');
			}
		}

		header( 'Content-Type: application/json; charset=utf-8' );
		$json = json_encode($set);
		echo $json;
		exit;

	}
	else if($get_method['method_name']=="get_favorite_post")
	{
		$jsonObj= array();	

		$type=trim($get_method['type']);	// song/radio
		$user_id=trim($get_method['user_id']);

		$jsonObj = array();

		switch ($type) {
			case 'song':
				{

					$query="SELECT tbl_mp3.*, tbl_category.* FROM tbl_mp3
							LEFT JOIN tbl_favorite ON tbl_mp3.`id`= tbl_favorite.`post_id`
							LEFT JOIN tbl_category ON tbl_mp3.`cat_id`=tbl_category.`cid` 
							WHERE tbl_mp3.`status`='1' AND tbl_category.`status`='1' AND tbl_favorite.`user_id`='$user_id' AND tbl_favorite.`type`='$type' ORDER BY tbl_favorite.`id` DESC";

					$sql = mysqli_query($mysqli, $query) or die(mysqli_error($mysqli));

					while ($data = mysqli_fetch_assoc($sql)) {

						$row['id'] = $data['id'];
						$row['cat_id'] = $data['cat_id'];
			 			$row['mp3_type'] = $data['mp3_type'];
						$row['mp3_title'] = $data['mp3_title'];
						
						$mp3_file=$data['mp3_url'];
						if($data['mp3_type']=='local'){
							$mp3_file=$file_path.'uploads/'.basename($data['mp3_url']);
						}

						$row['mp3_url'] = $mp3_file;
			 			 
						$row['mp3_thumbnail_b'] = $file_path.'images/'.$data['mp3_thumbnail'];
						$row['mp3_thumbnail_s'] = get_thumb('images/'.$data['mp3_thumbnail'],'300x300');
						 
						$row['mp3_duration'] = $data['mp3_duration'];
			 			$row['mp3_description'] = stripslashes($data['mp3_description']);
			 			$row['total_views'] = $data['total_views'];

			 			$row['is_favorite'] = is_favorite($data['id'],$user_id);

			  			$row['share_link'] = $file_path.'view_song.php?mp3_id='.$data['id'];

			 			$row['cid'] = $data['cid'];
						$row['category_name'] = $data['category_name'];
						$row['category_image'] = $file_path.'images/'.$data['category_image'];
						$row['category_image_thumb'] = get_thumb('images/'.$data['category_image'],'300x300');

						array_push($jsonObj, $row);
					}
				}
				break;

			case 'radio':
				{
					$query="SELECT tbl_radio.*, tbl_city.* FROM tbl_radio
							LEFT JOIN tbl_language ON tbl_radio.`lang_id`= tbl_language.`lid`
							LEFT JOIN tbl_city ON tbl_radio.`city_id`= tbl_city.`cid`
							LEFT JOIN tbl_favorite ON tbl_radio.`id`=tbl_favorite.`post_id`
							WHERE tbl_radio.`status`='1' AND tbl_language.`language_status`='1' AND tbl_city.`city_status`='1' AND tbl_favorite.`user_id`='$user_id' AND tbl_favorite.`type`='$type' ORDER BY tbl_favorite.`id` DESC";

					$sql = mysqli_query($mysqli, $query) or die(mysqli_error($mysqli));

					while ($data = mysqli_fetch_assoc($sql)) {

						$row['id'] = $data['id'];
						$row['city_id'] = $data['city_id'];
						$row['radio_name'] = $data['radio_name'];
						$row['radio_url'] = $data['radio_url'];
						$row['radio_description'] = stripslashes($data['radio_description']);
						$row['radio_frequency'] = $data['radio_frequency'];			  
						$row['video_thumbnail_b'] = $file_path.'images/'.$data['radio_image'];
						$row['video_thumbnail_s'] = get_thumb('images/'.$data['radio_image'],'300x300');
						$row['views'] = $data['views'];

						$row['language_name'] = get_lang($data['lang_id']);

						$row['is_favorite'] = is_favorite($data['id'],$user_id,'radio');

						$row['share_link'] = $file_path.'view_radio.php?radio_id='.$data['id'];

						$row['cid'] = $data['cid'];
						$row['city_name'] = $data['city_name'];
						$row['city_tagline'] = $data['city_tagline'];

						array_push($jsonObj, $row);
					}
				}
				break;
			
			default:
				{
				}
				break;
		}

		$set['ONLINE_RADIO'] = $jsonObj;

		header( 'Content-Type: application/json; charset=utf-8' );
		$json = json_encode($set);
		echo $json;
		exit;
	}
	else
  	{
  		$get_method = checkSignSalt($_POST['data']);
  	}
  
?>